/*************************************************************************************************************
                                 AMX Splash Effect

  Version: 0.1
  Author: KRoT@L

  0.1    Release


  Splash effect when bullets hit water.


  Cvar:

  splash_effect 0/1  -  0: disables the plugin
                        1: enables the plugin


  Setup:

  Install the amx file.
  Enabled VexdUM.


*************************************************************************************************************/


#include <amxmodx>
#include <amxmisc>
#include <engine>

new lastwpn[33]
new lastammo[33]
new g_bubblesprite, g_splash

#define SOUNDS_NUM 4
new g_sounds[SOUNDS_NUM][] = {
  "Splasheffectsounds/slosh1.wav",
  "Splasheffectsounds/slosh2.wav",
  "Splasheffectsounds/slosh3.wav",
  "Splasheffectsounds/slosh4.wav"
}

new g_ent

public plugin_init()
{
  register_plugin("Splash Effect", "0.1", "KRoTaL")
  register_cvar("splash_effect", "1")
  register_event("CurWeapon", "make_splash", "be", "3>0")
  g_ent = create_entity("info_target")
}

public plugin_precache()
{
  g_bubblesprite = precache_model("sprites/bubble.spr")
  g_splash = precache_model("sprites/wsplash3.spr")
  for (new i; i < SOUNDS_NUM; ++i)
    precache_sound(g_sounds[i])
}

stock waterInVicinity(Float:origin[3]) {
  new Float:traceEnds[8][3]

  traceEnds[0][0] = origin[0] - 2.0
  traceEnds[0][1] = origin[1] - 2.0
  traceEnds[0][2] = origin[2] - 2.0

  traceEnds[1][0] = origin[0] - 2.0
  traceEnds[1][1] = origin[1] - 2.0
  traceEnds[1][2] = origin[2] + 2.0

  traceEnds[2][0] = origin[0] + 2.0
  traceEnds[2][1] = origin[1] - 2.0
  traceEnds[2][2] = origin[2] + 2.0

  traceEnds[3][0] = origin[0] + 2.0
  traceEnds[3][1] = origin[1] - 2.0
  traceEnds[3][2] = origin[2] - 2.0

  traceEnds[4][0] = origin[0] - 2.0
  traceEnds[4][1] = origin[1] + 2.0
  traceEnds[4][2] = origin[2] - 2.0

  traceEnds[5][0] = origin[0] - 2.0
  traceEnds[5][1] = origin[1] + 2.0
  traceEnds[5][2] = origin[2] + 2.0

  traceEnds[6][0] = origin[0] + 2.0
  traceEnds[6][1] = origin[1] + 2.0
  traceEnds[6][2] = origin[2] + 2.0

  traceEnds[7][0] = origin[0] + 2.0
  traceEnds[7][1] = origin[1] + 2.0
  traceEnds[7][2] = origin[2] - 2.0

  for (new i = 0; i < 8; i++) {
    if (PointContents(traceEnds[i]) == CONTENTS_WATER)
    {
      return 1
    }
  }

  return 0
}

public make_splash(id)
{
  new wpn = read_data(2)
  new ammo = read_data(3)
  if(get_cvar_num("splash_effect") == 1 && lastwpn[id] == wpn && lastammo[id] > ammo)
  {
    new iHitOrigin[3]
    get_user_origin(id, iHitOrigin, 4)
    new Float:fHitOrigin[3]
    IVecFVec(iHitOrigin, fHitOrigin)
    new iPlOrigin[3]
    get_user_origin(id, iPlOrigin, 1)
    new Float:fPlOrigin[3]
    IVecFVec(iPlOrigin, fPlOrigin)
    new Float:fVector[3]
    fVector[0] = fHitOrigin[0] - fPlOrigin[0]
    fVector[1] = fHitOrigin[1] - fPlOrigin[1]
    fVector[2] = fHitOrigin[2] - fPlOrigin[2]
    new Float:length = vector_length(fVector)
    fVector[0] = fVector[0] / length * 10
    fVector[1] = fVector[1] / length * 10
    fVector[2] = fVector[2] / length * 10
    new water = 0
    new Float:fEndOrigin[3]
    fEndOrigin[0] = fPlOrigin[0] + fVector[0]
    fEndOrigin[1] = fPlOrigin[1] + fVector[1]
    fEndOrigin[2] = fPlOrigin[2] + fVector[2]
    new i = 0
    while(!trace_line(id, fPlOrigin, fEndOrigin, fPlOrigin) && i < 2000)
    {
      if(waterInVicinity(fPlOrigin))
      {
        water = 1
        break
      }
      fEndOrigin[0] = fPlOrigin[0] + fVector[0]
      fEndOrigin[1] = fPlOrigin[1] + fVector[1]
      fEndOrigin[2] = fPlOrigin[2] + fVector[2]
      i++
    }
    if(water)
    {
      FVecIVec(fPlOrigin, iHitOrigin)

      message_begin(MSG_BROADCAST, SVC_TEMPENTITY, iHitOrigin)
      write_byte(114)
      write_coord(iHitOrigin[0])
      write_coord(iHitOrigin[1])
      write_coord(iHitOrigin[2])
      write_coord(iHitOrigin[0])
      write_coord(iHitOrigin[1])
      write_coord(iHitOrigin[2])
      write_coord(40)
      write_short(g_bubblesprite)
      write_byte(10)
      write_coord(40)
      message_end()

      message_begin(MSG_BROADCAST, SVC_TEMPENTITY, iHitOrigin);
      write_byte(17)
      write_coord(iHitOrigin[0])
      write_coord(iHitOrigin[1])
      write_coord(iHitOrigin[2]+12)
      write_short(g_splash)
      write_byte(10)
      write_byte(128)
      message_end()

      entity_set_origin(g_ent, fPlOrigin)
      emit_sound(g_ent, CHAN_AUTO, g_sounds[random(SOUNDS_NUM)], VOL_NORM, ATTN_NORM, 0, PITCH_NORM) 
    }
  }
  lastwpn[id] = wpn
  lastammo[id] = ammo
}
